/*!
 * MediaElement.js
 * http://www.mediaelementjs.com/
 *
 * Wrapper that mimics native HTML5 MediaElement (audio and video)
 * using a variety of technologies (pure JavaScript, Flash, iframe)
 *
 * Copyright 2010-2017, John Dyer (http://j.hn/)
 * License: MIT
 *
 */
!function e(t,a,r){function s(o,i){if(!a[o]){if(!t[o]){var c="function"==typeof require&&require;if(!i&&c)return c(o,!0);if(n)return n(o,!0);var l=new Error("Cannot find module '"+o+"'");throw l.code="MODULE_NOT_FOUND",l}var u=a[o]={exports:{}};t[o][0].call(u.exports,function(e){var a=t[o][1][e];return s(a||e)},u,u.exports,e,t,a,r)}return a[o].exports}for(var n="function"==typeof require&&require,o=0;o<r.length;o++)s(r[o]);return s}({1:[function(e,t,a){"use strict";var r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},s={name:"chromecast",options:{prefix:"chromecast"},canPlayType:function(){return!0},create:function(e,t){var a={},r=function(e){var t=e.description?" : "+e.description:".",a=void 0;switch(e.code){case chrome.cast.ErrorCode.API_NOT_INITIALIZED:a="The API is not initialized"+t;break;case chrome.cast.ErrorCode.CANCEL:a="The operation was canceled by the user"+t;break;case chrome.cast.ErrorCode.CHANNEL_ERROR:a="A channel to the receiver is not available"+t;break;case chrome.cast.ErrorCode.EXTENSION_MISSING:a="The Cast extension is not available"+t;break;case chrome.cast.ErrorCode.INVALID_PARAMETER:a="The parameters to the operation were not valid"+t;break;case chrome.cast.ErrorCode.RECEIVER_UNAVAILABLE:a="No receiver was compatible with the session request"+t;break;case chrome.cast.ErrorCode.SESSION_ERROR:a="A session could not be created, or a session was invalid"+t;break;case chrome.cast.ErrorCode.TIMEOUT:a="The operation timed out"+t;break;default:a="Unknown error: "+e.code}console.error(a)},s=e.castPlayer,n=e.castPlayerController,o=1;a.options=t,a.id=e.id+"_"+t.prefix,a.mediaElement=e;for(var i=mejs.html5media.properties,c=0,l=i.length;c<l;c++)!function(t){var r=""+t.substring(0,1).toUpperCase()+t.substring(1);a["get"+r]=function(){if(null!==s){switch(t){case"currentTime":return s.currentTime;case"duration":return s.duration;case"volume":return o=s.volumeLevel;case"paused":return s.isPaused;case"ended":return s.ended;case"muted":return s.isMuted;case"src":return e.originalNode.getAttribute("src");case"readyState":return 4}return null}return null},a["set"+r]=function(r){if(null!==s)switch(t){case"src":var i="string"==typeof r?r:r[0].src;e.originalNode.setAttribute("src",i);break;case"currentTime":s.currentTime=r,n.seek(),setTimeout(function(){var t=mejs.Utils.createEvent("timeupdate",a);e.dispatchEvent(t)},50);break;case"muted":!0!==r||s.isMuted?!1===r&&s.isMuted&&n.muteOrUnmute():n.muteOrUnmute(),setTimeout(function(){var t=mejs.Utils.createEvent("volumechange",a);e.dispatchEvent(t)},50);break;case"volume":o=r,s.volumeLevel=r,n.setVolumeLevel(),setTimeout(function(){var t=mejs.Utils.createEvent("volumechange",a);e.dispatchEvent(t)},50);break;case"readyState":var c=mejs.Utils.createEvent("canplay",a);e.dispatchEvent(c);break;case"playbackRate":e.originalNode.playbackRate=r;break;default:console.log("Chromecast "+a.id,t,"UNSUPPORTED property")}}}(i[c]);for(var u=mejs.html5media.methods,d=0,m=u.length;d<m;d++)!function(o){a[o]=function(){if(null!==s)switch(o){case"play":s.isPaused&&(n.playOrPause(),setTimeout(function(){var t=mejs.Utils.createEvent("play",a);e.dispatchEvent(t)},50));break;case"pause":s.isPaused||(n.playOrPause(),setTimeout(function(){var t=mejs.Utils.createEvent("pause",a);e.dispatchEvent(t)},50));break;case"load":var i=e.originalNode.getAttribute("src"),c=mejs.Utils.getTypeFromFile(i),l=new chrome.cast.media.MediaInfo(i,c),u=cast.framework.CastContext.getInstance().getCurrentSession();if(!0===t.castEnableTracks){for(var d=[],m=e.originalNode.children,p=1,v=0,f=m.length;v<f;v++){var y=m[v];if("track"===y.tagName.toLowerCase()&&("subtitles"===y.getAttribute("kind")||"captions"===y.getAttribute("kind"))){var E=new chrome.cast.media.Track(p,chrome.cast.media.TrackType.TEXT);E.trackContentId=mejs.Utils.absolutizeUrl(y.getAttribute("src")),E.trackContentType="text/vtt",E.subtype=chrome.cast.media.TextTrackType.SUBTITLES,E.name=y.getAttribute("label"),E.language=y.getAttribute("srclang"),E.customData=null,d.push(E),p++}}l.textTrackStyle=new chrome.cast.media.TextTrackStyle,l.tracks=d}l.metadata=new chrome.cast.media.GenericMediaMetadata,l.streamType=chrome.cast.media.StreamType.BUFFERED,l.customData=null,l.duration=null,e.originalNode.getAttribute("data-cast-title")&&(l.metadata.title=e.originalNode.getAttribute("data-cast-title")),e.originalNode.getAttribute("data-cast-description")&&(l.metadata.subtitle=e.originalNode.getAttribute("data-cast-description")),e.originalNode.getAttribute("poster")&&(l.metadata.images=[{url:mejs.Utils.absolutizeUrl(e.originalNode.getAttribute("poster"))}]);var h=new chrome.cast.media.LoadRequest(l);u.loadMedia(h).then(function(){var t=e.originalNode.getCurrentTime();a.setCurrentTime(t),n.playOrPause(),setTimeout(function(){var t=mejs.Utils.createEvent("play",a);e.dispatchEvent(t)},50)},function(e){r(e)})}}}(u[d]);return window["__ready__"+a.id]=function(){n.addEventListener(cast.framework.RemotePlayerEventType.IS_PAUSED_CHANGED,function(){s.isPaused?a.pause():a.play()}),n.addEventListener(cast.framework.RemotePlayerEventType.IS_MUTED_CHANGED,function(){return a.setMuted(s.isMuted)}),n.addEventListener(cast.framework.RemotePlayerEventType.IS_MEDIA_LOADED_CHANGED,function(){setTimeout(function(){var t=mejs.Utils.createEvent("loadedmetadata",a);e.dispatchEvent(t)},50)}),n.addEventListener(cast.framework.RemotePlayerEventType.VOLUME_LEVEL_CHANGED,function(){var t=mejs.Utils.createEvent("volumechange",a);e.dispatchEvent(t)}),n.addEventListener(cast.framework.RemotePlayerEventType.DURATION_CHANGED,function(){setTimeout(function(){var t=mejs.Utils.createEvent("timeupdate",a);e.dispatchEvent(t)},50)}),n.addEventListener(cast.framework.RemotePlayerEventType.CURRENT_TIME_CHANGED,function(){setTimeout(function(){var t=mejs.Utils.createEvent("timeupdate",a);e.dispatchEvent(t)},50),e.castPlayer.currentTime>=e.castPlayer.duration&&setTimeout(function(){var t=mejs.Utils.createEvent("ended",a);e.dispatchEvent(t)},50)}),n.addEventListener(cast.framework.RemotePlayerEventType.IS_MUTED_CHANGED,function(){return a.setMuted(s.isMuted)}),a.load()},e.autoplay=!1,window["__ready__"+a.id](),a.setSize=function(){},a.hide=function(){},a.show=function(){},a.destroy=function(){null!==s&&n.stop(),e.style.display=""},a}};mejs.i18n.en["mejs.chromecast-legend"]="Casting to:",Object.assign(mejs.MepDefaults,{castTitle:null,castAppID:null,castPolicy:"origin",castEnableTracks:!1}),Object.assign(MediaElementPlayer.prototype,{buildchromecast:function(e,t,a,n){var o=this,i=document.createElement("div"),c=mejs.Utils.isString(o.options.castTitle)?o.options.castTitle:"Chromecast";if(e.isVideo&&document.createElement("google-cast-button").constructor!==HTMLElement){e.chromecastLayer=document.createElement("div"),e.chromecastLayer.className=o.options.classPrefix+"chromecast-layer "+o.options.classPrefix+"layer",e.chromecastLayer.innerHTML='<div class="'+o.options.classPrefix+'chromecast-info"></div>',e.chromecastLayer.style.display="none",a.insertBefore(e.chromecastLayer,a.firstChild),i.className=o.options.classPrefix+"button "+o.options.classPrefix+"chromecast-button",i.innerHTML='<button type="button" is="google-cast-button" aria-controls="'+o.id+'" title="'+c+'" aria-label="'+c+'" tabindex="0"></button>',o.addControlElement(i,"chromecast"),o.castButton=i,e.chromecastLayer.innerHTML='<div class="'+o.options.classPrefix+'chromecast-container"><span class="'+o.options.classPrefix+'chromecast-icon"></span><span class="'+o.options.classPrefix+'chromecast-info">'+mejs.i18n.t("mejs.chromecast-legend")+' <span class="device"></span></span></div>',n.originalNode.getAttribute("poster")&&(e.chromecastLayer.innerHTML+='<img src="'+n.originalNode.getAttribute("poster")+'" width="100%" height="100%">');var l=!1;l||(window.__onGCastApiAvailable=function(t){if(t){mejs.Renderers.add(s),i.style.width="20px",setTimeout(function(){o.setPlayerSize(o.width,o.height),o.setControlsSize()},0);var c=void 0;switch(o.options.castPolicy){case"tab":c="TAB_AND_ORIGIN_SCOPED";break;case"page":c="PAGE_SCOPED";break;default:c="ORIGIN_SCOPED"}cast.framework.CastContext.getInstance().setOptions({receiverApplicationId:o.options.castAppID||chrome.cast.media.DEFAULT_MEDIA_RECEIVER_APP_ID,autoJoinPolicy:chrome.cast.AutoJoinPolicy[c]}),n.castPlayer=new cast.framework.RemotePlayer,n.castPlayerController=new cast.framework.RemotePlayerController(n.castPlayer);var l=0;n.castPlayerController.addEventListener(cast.framework.RemotePlayerEventType.IS_CONNECTED_CHANGED,function(){if(cast&&cast.framework&&n.castPlayer.isConnected){var t=function(){var t=n.getSrc(),r=[{src:t,type:mejs.Utils.getTypeFromFile(t)}],s=mejs.Renderers.select(r,["chromecast"]);n.changeRenderer(s.rendererName,r);var i=cast.framework.CastContext.getInstance().getCurrentSession();return a.querySelector("."+o.options.classPrefix+"chromecast-info").querySelector(".device").innerText=i.getCastDevice().friendlyName,e.chromecastLayer.style.display="block",!0===o.options.castEnableTracks&&function(){var t=void 0!==e.captionsButton?e.captionsButton.querySelectorAll("input[type=radio]"):null;if(null!==t)for(var a=0,r=t.length;a<r;a++)!function(e,a){t[e].addEventListener("click",function(){var a=parseInt(t[e].id.replace(/^.*?track_(\d+)_.*$/,"$1")),r="none"===t[e].value?[]:[a],s=new chrome.cast.media.EditTracksInfoRequest(r);i.getMediaSession().editTracksInfo(s,function(){},function(e){console.error(e)})})}(a)}(),n.addEventListener("timeupdate",function(){l=n.getCurrentTime()}),{v:void 0}}();if("object"===(void 0===t?"undefined":r(t)))return t.v}e.chromecastLayer.style.display="none",n.style.display="";var s=mejs.Renderers.select(mediaFiles,n.renderers);n.changeRenderer(s.rendererName,mediaFiles),n.setCurrentTime(l),l>0&&!mejs.Features.IS_IOS&&!mejs.Features.IS_ANDROID&&n.play()})}},mejs.Utils.loadScript("https://www.gstatic.com/cv/js/sender/v1/cast_sender.js?loadCastFramework=1"),l=!0)}},clearchromecast:function(e){e.castPlayerController.stop(),e.castButton&&e.castButton.remove(),e.chromecastLayer&&e.chromecastLayer.remove()}})},{}]},{},[1]);